import random
import math
import string
import time

class node:
    def __init__(self, strg):
        self.name = strg     # Name, a string
        self.left = None     # Left subtree
        self.right = None    # Right subtree
        self.val = -1        # Value connected with name
        self.bal = 0         # Balance value
        
    def insert (self, nam, p):
        if nam < p.name:             # Go left
            if p.left == None:       # New leaf
                p.left = node(nam)
                p.bal -= 1
            else:
                self.insert (nam, p.left)
        elif nam > p.name:          # Go right
            if p.right == None:
                p.right = node (nam)
                p.bal += 1
            else:
                self.insert (nam, p.right)
            
            
    def repr (self, level):
        ret = "\t"*level+repr(self.name)+str(self.bal)+"\n"
        for child in [self.left, self.right]:
            if child != None: ret += child.repr(level+1)
        return ret
        
        
class avlTree:
    def __init__(self):
        self.root = None

    def insert (self, nam):
        if self.root==None:
            self.root = node(nam)
            self.root.bal = 0
            return 0
        self.root.insert (nam, self.root)
        return self.root.bal
        
    def _insert (self, nam, p):
        if nam < p.name:
            if p.left==None:
                p.left = node(nam)
                p.bal = p.bal - 1
                print ("New left node for ", nam, ", ", p.left.bal, p.bal)
            else:
                self._insert (nam, p.left)+p.bal
                p.bal = p.bal + p.left.bal
                print ("Insert left ", p.bal, p.left.bal)
        else:
            if p.right==None:
                p.right = node(nam)
                p.bal = p.bal + 1
                print ("New right node for ", nam, ", ", p.right.bal, p.bal)
            else:
                self._insert (nam, p.right)+p.bal
                p.bal = p.bal + p.right.bal
                print ("Insert right ", p.bal, p.right.bal)
        return p.bal
                
    def find (self, nam):
        return self._find (nam, self.root)

    def _find (self, nam, tree):
        if tree.name == nam:
            return tree
        elif nam < tree.name:
            if tree.left == None:
                return None
            else:
                return self._find (nam, tree.left)
        else:
            if tree.right == None:
                return None;
            else:
                return self._find (nam, tree.right)
        return None
    
    def pri (self):
        self._pri (self.root)
            
    def _pri (self, p):
        if p.left != None:
            self._pri (p.left)
        print (p.name, "=", p.bal)
        if p.right != None:
            self._pri (p.right)

    def repr (self, level=0):
        return self.root.repr(level)
     

def randomString(stringLength=10):
    """Generate a random string of fixed length """
    letters = string.ascii_lowercase
    return ''.join(random.choice(letters) for i in range(stringLength))


lst = []
for i in range(0,10):
    s = randomString()
    lst.append(s)
nolst = []
for i in range(0,10):
    s = randomString()
    nolst.append(s)



t0 = time.time()          # ------------- Binary tree -------------

root = avlTree()
for i in range(0,10):
    s = lst[i]
    root.insert (s)
    
for i in range(1,10):
    k = root.find(lst[i])
    if k==None: print ( "-")
root.pri()
#    if kk.value > 0:
#        print ("Tree found ", kk.value)
#        print (lst[0])
#        exit()
t1 = time.time()
total_n = t1-t0
print ("Balanced tree ", total_n)
print (root.repr ())